getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

# tempdir()
# dir.create(tempdir())
load("data4.RData")
load("c.pre.to.list.3.RData")

data.x <- data4$x0[2996:3360,]
data.y <- data4$y0[,,2996:3360]

dim.f = dim(data.y)[1:2]
d = ncol(data.x); lower.x = apply(data.x,2,min); upper.x = apply(data.x,2,max)

dim.s = c(2,2)
dim.h = prod(dim.s); dim.mode = length(dim.s)

N = nrow(data.x)
x0 = data.x; y0 = data.y

h <- function(y) sum(y)

ind.x.star = which.max(apply(y0,3,h))
h.star = apply(y0,3,h)[ind.x.star]
full.x.star = x0[ind.x.star,]

ind.x.star; h.star; full.x.star



################################################################################
## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  dis.x = norm1(x1,x2)
  theta0 = rep(list(theta),d)
  dis = Map(function(x0,th) x0/th,dis.x,theta0)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

B.tuck.to <- function(y,n){
  y0 = lapply(1:n, function(i) rTensor::as.tensor(y[,,i]))
  U.tuck = list()
  
  mode.unfold <- function(da,k) do.call(cbind, lapply(da, function(x) {k_unfold(x,k)@data}))
  for(i in 1:dim.mode) U.tuck[[i]] = svd(mode.unfold(y0, i))$u[, 1:dim.s[i]]
  core.ten = lapply(y0, function(x) ttl(x, lapply(U.tuck, t), 1:dim.mode))
  
  return(list(core.ten=core.ten, U.tuck=U.tuck))
}
# b.ren = B.tuck.to(y,n)


################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-TOGP
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]-1)/2
}
for(th.lab in (dim.mode+1):(2*dim.mode)){
  vec.lab[[th.lab]] = dim.s[th.lab-dim.mode]#*d
}
vec.lab[[2*dim.mode+1]] = vec.lab[[2*dim.mode+2]] = 1

group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.to = length(group.lab)

lower.th = c(unlist(Map(rep, c(1e-3,1e-3,1e-3,1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(pi,pi,10,10,10,1e-2), unlist(vec.lab))))

sig.to <- function(t0, omega){
  O = matrix(0,t0,t0)
  O[lower.tri(O, diag = FALSE)] <- omega
  
  L <- matrix(0, t0, t0); L[lower.tri(L, diag = TRUE)] = 1
  sin_prod <- unlist(apply(as.matrix(O[-1,]),1,function(row) cumprod(sin(row[which(row!=0)]))))
  L[-1,-1][lower.tri(L[-1,-1],diag=TRUE)] <- sin_prod
  L[-1,-1][lower.tri(L[-1,-1],diag=FALSE)] <- cos(O[-1,-1][lower.tri(O[-1,-1],diag=FALSE)])*
    L[-1,-1][lower.tri(L[-1,-1],diag=FALSE)]
  L[2:t0, 1] = cos(O[c(2:t0),1])
  return(L)
}


k.mode.to <- function(x1,x2,t0,omega,theta){
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  theta = matrix(theta,t0,1)
  k_x = matrix(apply(theta,1,function(psi) ker.sele(x1,x2,psi,mat0)),n.s1*n.s2,t0)
  
  result = apply(k_x,1,function(x) sig.to(t0,omega)%*%diag(x)%*%t(sig.to(t0,omega)))
  result1 = array(c(result), dim=c(t0,t0,n.s1*n.s2))
  result2 <- lapply(seq_len(n.s1*n.s2), function(k) result1[,,k])
  dim(result2) <- c(n.s1,n.s2)
  return(result2)
}
# k.mode.to(x,x,t0,omega,theta)[1,2][[1]]-k.mode.to(x[3,],x[5,],t0,omega,theta)[1,1][[1]]


ker.to <- function(x1,x2,the){
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  the0 = split(the, group.lab)
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]],the0[[i+dim.mode]])
  
  K = lapply(Omega,function(the) t(k.mode.to(x1,x2,the[[1]],the[[2]],the[[3]])))
  
  K.vec = mapply(function(x, y) {
    kronecker(x, y)
  }, K[[1]], K[[2]], SIMPLIFY = FALSE)
  dim(K.vec) <- c(n.s1, n.s2)
  
  K.rows = lapply(1:n.s1, function(i) {
    do.call(cbind, K.vec[(i-1)*n.s2 + 1:n.s2])
  })
  K.re = do.call(rbind, K.rows)
  return(K.re) 
}
# ker.to(x,x,runif(dim.hyper.to))


der.l.th_om <- function(x1,x2,t0,omega,theta){
  ## der.l.th_lij
  x1 = matrix(x1,length(x1)/d,d); x2 = matrix(x2,length(x2)/d,d)
  n.s1 = nrow(x1); n.s2 = nrow(x2)
  theta0 = matrix(theta,t0,1)
  
  k_x = matrix(apply(theta0,1,function(psi) ker.sele(x1,x2,psi,mat0)),n.s1*n.s2,t0)
  A_l = sig.to(t0,omega)
  
  der.kx_l.th = as.matrix(apply(theta0,1,function(theta) jacobian(function(th) ker.sele(x1,x2,th,mat0), theta)))
  der.k_l.th0 = lapply(1:t0, function(l) 
    array(sapply(1:(n.s1*n.s2), function(i) der.kx_l.th[i,l]*A_l[,l]%*%t(A_l[,l])), c(t0,t0,(n.s1*n.s2))))
  
  der.k_l.th = lapply(der.k_l.th0, function(arr) {
    slices <- lapply(seq_len(dim(arr)[3]), function(i) arr[,,i])
    dim(slices) = c(n.s1, n.s2)
    return(slices)
  })
  
  der.a_l.phi0 = jacobian(function(om) sig.to(t0,om), omega)
  der.a_l.phi = lapply(seq_len(t0*(t0-1)/2), function(i) matrix(der.a_l.phi0[, i],t0,t0))
  
  der.k_l.phi0 = lapply(1:(t0*(t0-1)/2), function(l) 
    array(sapply(1:(n.s1*n.s2),function(i) der.a_l.phi[[l]]%*%diag(k_x[i,])%*%t(A_l)+A_l%*%diag(k_x[i,])%*%t(der.a_l.phi[[l]])), c(t0,t0,(n.s1*n.s2))))
  
  der.k_l.phi = lapply(der.k_l.phi0, function(arr) {
    slices <- lapply(seq_len(dim(arr)[3]), function(i) arr[,,i])
    dim(slices) = c(n.s1, n.s2)
    return(slices)
  })
  
  return(list(der.k_l.th=der.k_l.th, der.k_l.phi=der.k_l.phi))
}
# der.l.th_om(x,x,4,runif(6),runif(4))


der.l <- function(x,y,n,the){
  the0 = split(the[1:dim.hyper.to], group.lab)
  
  ome = list(); for(i in 1:dim.mode) ome[[i]] = the0[[i]]
  th = list(); for(i in 1:dim.mode) th[[i]] = the0[[i+dim.mode]]
  sig2 = the0[[2*dim.mode+1]]; tau2 = the0[[2*dim.mode+2]]
  
  k.ini = ker.to(x,x,the[1:dim.hyper.to])
  k.y = sig2*k.ini + tau2*diag(n*dim.h)
  sol.k.y = solve(k.y)
  al.k = sol.k.y%*%c(y)
  
  der.l.sig2 = tr(sol.k.y%*%k.ini)-t(al.k)%*%k.ini%*%al.k
  der.l.tau2 = tr(sol.k.y)-t(al.k)%*%al.k
  
  der.l.k <- function(a) tr(sig2*sol.k.y%*%a)-t(al.k)%*%a%*%al.k
  
  x = matrix(x,length(x)/d,d); n.s1 = n.s2 = nrow(x)
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],ome[[i]],th[[i]])
  K = lapply(Omega,function(the) k.mode.to(x,x,the[[1]],the[[2]],the[[3]]))
  
  der.l = lapply(Omega,function(the) der.l.th_om(x,x,the[[1]],the[[2]],the[[3]]))
  der.l.th = map(der.l, 1); der.l.phi = map(der.l, 2)
  
  K.list.func <- function(a,b) mapply(function(x, y) {
    kronecker(x, y)
  }, a, b, SIMPLIFY = FALSE)
  
  der.like.th = der.like.phi = list()
  for(l in 1:dim.mode){
    if (l==1){
      list2 = K[[2]]
      der.K.th = lapply(der.l.th[[1]], function(b) {
        re1 = K.list.func(b,list2); dim(re1) = c(n.s1,n.s2)
        re1.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re1[(i-1)*n.s2 + 1:n.s2])
        })
        re1.re = do.call(rbind, re1.rows); return(re1.re)
      })
      der.K.phi = lapply(der.l.phi[[1]], function(b) {
        re2 = K.list.func(b,list2); dim(re2) = c(n.s1,n.s2)
        re2.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re2[(i-1)*n.s2 + 1:n.s2])
        })
        re2.re = do.call(rbind, re2.rows); return(re2.re)
      })
      der.like.th[[1]] = lapply(der.K.th, der.l.k)
      der.like.phi[[1]] = lapply(der.K.phi, der.l.k)
    }
    if (l==2){
      list1 = K[[1]]
      der.K.th = lapply(der.l.th[[2]], function(b) {
        re1 = K.list.func(list1,b); dim(re1) = c(n.s1,n.s2)
        re1.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re1[(i-1)*n.s2 + 1:n.s2])
        })
        re1.re = do.call(rbind, re1.rows); return(re1.re)
      })
      der.K.phi = lapply(der.l.phi[[2]], function(b) {
        re2 = K.list.func(list1,b); dim(re2) = c(n.s1,n.s2)
        re2.rows = lapply(1:n.s1, function(i) {
          do.call(cbind, re2[(i-1)*n.s2 + 1:n.s2])
        })
        re2.re = do.call(rbind, re2.rows); return(re2.re)
      })
      der.like.th[[2]] = lapply(der.K.th, der.l.k)
      der.like.phi[[2]] = lapply(der.K.phi, der.l.k)
    }
  }
  
  result = list(der.like.th=der.like.th, der.like.phi=der.like.phi, 
                der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}
# der.l(x,y,k.ind,n,runif(dim.hyper.to))


likeli.to <- function(x,y,n,the){
  the0 = split(the, group.lab)
  k.ini = ker.to(x,x,the)
  sig2 = the0[[2*dim.mode+1]]; tau2 = the0[[2*dim.mode+2]]
  
  log.likeli = determinant(sig2*k.ini+tau2*diag(n*dim.h),logarithm=TRUE)$modulus+
    t(c(y))%*%solve(sig2*k.ini+tau2*diag(n*dim.h))%*%c(y)
  return(list(like=log.likeli, the0=the0))
}
# likeli.to(x.train,y0.train,n,runif(dim.hyper.to))


togp.hat <- function(x.new,x,y,n,n.test,hy){
  x.new = matrix(x.new,n.test,d)
  sig2 = hy[[2*dim.mode+1]]; tau2 = hy[[2*dim.mode+2]]
  
  k.ini = sig2*ker.to(x,x,unlist(hy))
  k.to.1 = sig2*ker.to(x.new,x,unlist(hy))
  k.to.0 = sig2*ker.to(x.new,x.new,unlist(hy))
  
  k.oth = k.to.1%*%solve(k.ini+tau2*diag(n*dim.h))
  
  f.hat.tuck = k.oth%*%c(y)
  var.hat.tuck = k.to.0-k.oth%*%t(k.to.1)
  
  result = list(mean.tuck=f.hat.tuck, cov.tuck=var.hat.tuck)
  return(result)
}
# hy=list(split(runif(dim.hyper.to), group.lab),c(1,0.01))



################################################################################
## Our proposed method: NS-TOGP-UCB
n = c.ini.set$n; m = c.ini.set$m; J.for = c.ini.set$J.for

like.re.to = hyper.to = fhat = lapply(1:J.for, function(x) list())
x0.to = y0.to = y0.tuck.to = ind.x.to = list()
togp.bo = h.to = list()
regret.to = ins.regret.to = cum.regret.to = list()
beta.to = ucb.new.to = lapply(1:J.for, function(x) list())

for(j.for.to in 1:J.for){
  ind.x = c.ini.set$ind.x.for.new[[j.for.to]]
  x = data.x[ind.x,]; y=y0[,,ind.x]
  
  y0.tuck = B.tuck.to(y,n); B.tuck = Reduce(kronecker,y0.tuck$U.tuck)
  y0.0 = lapply(y0.tuck$core.ten, function(c) c@data)
  y.tuck = abind(y0.0, along = dim.mode+1)
  
  hyper.to.old = directL(function(the) likeli.to(x,y.tuck,n,the)$like,
                         lower.th,upper.th,control=list(xtol_rel=1e-8, maxeval=1000))$par
  hyper.to.new = optim(par = hyper.to.old,
                       fn = function(the) likeli.to(x,y.tuck,n,the)$like,
                       gr = function(the) unlist(der.l(x,y.tuck,n,the)),
                       method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  
  like.re.to[[j.for.to]][[1]] = likeli.to(x,y.tuck,n,hyper.to.new)
  hyper.to[[j.for.to]][[1]] = like.re.to[[j.for.to]][[1]]$the0
  
  
  x0 = data.x; inx0 = c(1:N)
  x0.to[[j.for.to]] = x; y0.to[[j.for.to]] = y; ind.x.to[[j.for.to]] = ind.x
  y0.tuck.to[[j.for.to]] = y.tuck; n.to = n
  
  x.new.to = t(as.matrix(x[which.max(apply(y,3,h)),]))
  y.new.to = y[,,which.max(apply(y,3,h))]
  
  hyper.to.ucb = unlist(hyper.to[[j.for.to]][[1]]); delta.to = 0.05
  fhat[[j.for.to]][[1]] = togp.hat(x.new.to,x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],
                                   n.to,1,hyper.to[[j.for.to]][[1]])
  
  for(i.to in 1:m){
    ind.x.new.to = sample(inx0[-ind.x.to[[j.for.to]]],1) #which(apply(x0, 1, function(row) all(row == x0[-ind.x.to[[j.for.to]],][which.min(ucb.x),])))[1]
    x.new.to = x0[ind.x.new.to,]; y.new.to = y0[,,ind.x.new.to]
    y.tuck.new.to = abind(ttl(rTensor::as.tensor(y.new.to), 
                              lapply(y0.tuck$U.tuck,t), 1:dim.mode)@data, along=dim.mode+1)
    
    fhat[[j.for.to]][[i.to+1]] = togp.hat(x.new.to,x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],
                                          n.to,n.test=1,hyper.to[[j.for.to]][[i.to]])
    
    x0.to[[j.for.to]] = rbind(x0.to[[j.for.to]], x.new.to)
    y0.to[[j.for.to]] = abind(y0.to[[j.for.to]], y.new.to, along = dim.mode+1)
    y0.tuck.to[[j.for.to]] = abind(y0.tuck.to[[j.for.to]], y.tuck.new.to, along = dim.mode+1)
    ind.x.to[[j.for.to]] = c(ind.x.to[[j.for.to]],ind.x.new.to)
    n.to = n+i.to
    
    if(i.to %% 150 == 0){
      hyper.to.ucb = optim(par = unlist(hyper.to[[j.for.to]][[i.to]]), 
                           fn = function(the) likeli.to(x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],n.to,the)$like, 
                           gr = function(the) unlist(der.l(x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],n.to,the)), 
                           method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.to.ucb = hyper.to.ucb
    }
    
    like.re.to[[j.for.to]][[i.to+1]] = likeli.to(x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],
                                                 n.to,hyper.to.ucb)
    hyper.to[[j.for.to]][[i.to+1]] = like.re.to[[j.for.to]][[i.to+1]]$the0
    print(i.to)
  }
  
  togp.ucb <- function(x.new,ind.new) togp.hat(x.new,x0.to[[j.for.to]],y0.tuck.to[[j.for.to]],
                                               n.to,n.test=1,hyper.to[[j.for.to]][[i.to+1]]) 
  togp.bo[[j.for.to]] = togp.ucb
  
  h.to[[j.for.to]] = apply(y0.to[[j.for.to]],dim.mode+1,h)
  regret.to[[j.for.to]] = h.star-h.to[[j.for.to]]
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.to-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.to[[j.for.to]])[n],h.star))
  lines(cummax(h.to[[j.for.to]])[n:n.to],type="b",lwd=3,lty=2,pch=2,col=2)
  
  ins.regret.to[[j.for.to]] = h.star-cummax(h.to[[j.for.to]][(n+1):n.to])
  cum.regret.to[[j.for.to]] = cumsum(ins.regret.to[[j.for.to]])
  
  plot(cumsum(ins.regret.to[[j.for.to]]),type="b",lwd=3,lty=2,pch=2,col=2)
  print(j.for.to)
}

fto.rs.list = list(ind.x.star=ind.x.star, h.star=h.star, full.x.star=full.x.star,
                    like.re.to=like.re.to, hyper.to=hyper.to, fhat=fhat,
                    ind.x.for=ind.x.for, k.ind.for=k.ind.for,
                    x0.to=x0.to, y0.to=y0.to, togp.bo=togp.bo, ind.x.to=ind.x.to,
                    h.to=h.to, regret.to=regret.to, ins.regret.to=ins.regret.to, cum.regret.to=cum.regret.to,
                    beta.to=beta.to, ucb.new.to=ucb.new.to)
save(fto.rs.list, file="c4.fto.rs.list.RData")


# c.ini.set = list(n=n, m=m, J.for=J.for, ind.x.for=ind.x.for)
# save(c.ini.set, file="c4-f-setting.RData")




























